@echo off
set _AOPT=
set _IOPT=
if "%1"=="-a" set _AOPT=-a
if "%1"=="-A" set _AOPT=-a
if "%1"=="/a" set _AOPT=-a
if "%1"=="/A" set _AOPT=-a
if not "%_AOPT%"=="" shift
if "%1"=="-s" set _IOPT=-iscan.dir
if "%1"=="-S" set _IOPT=-iscan.dir
if "%1"=="/s" set _IOPT=-iscan.dir
if "%1"=="/S" set _IOPT=-iscan.dir
if not "%_IOPT%"=="" shift
if "%1"=="0" goto MakeChanged
if "%1"=="1" goto Start
if "%1"=="2" goto Start
if "%1"=="3" goto Start

echo MAKETREE, Version 1.23
echo. 
echo Builds an entire directory tree starting at the current working directory.
echo. 
echo Usage:  MAKETREE [/A] [/S] level
echo.
echo  /A   Include all subdirectories in the keyword database.
echo  /S   Include only directories with the file "scan.dir" in the database.
echo.
echo level 
echo   0   Builds indexes and slides only for directories that changed
echo       (calls "makeindx.bat" in each subdirectory).
echo. 
echo   1   a) Creates a keyword database or updates the index database
echo       b) Updates all symlinks files (calls "makelink.bat" in each subdirectory)
echo       c) Builds indexes and slides in directories that changed
echo          (calls "makeindx.bat" in each subdirectory)
echo. 
echo   2   Same as #1 above, but forces a rebuild of all indexes, even in
echo       directories that didn't change.
echo. 
echo   3   Rebuilds everything.
echo. 
echo If the current working directory does not contain an "icons" subdirectory and
echo it does not contain an existing keyword database, the keyword database will
echo not be created.
echo. 
goto End

:Start
echo -------------------------------------------------------------------------------
echo Making indexes and slides (pass 1):
echo. 
if "%1"=="0" mkhtmtree
if "%1"=="1" mkhtmtree
if "%1"=="2" mkhtmtree /a
if "%1"=="3" global /f /s makeindx.bat

set _IDB=
if "%_IDB%"=="" if exist index.db set _IDB=.
if "%_IDB%"=="" if exist ..\index.db set _IDB=..
if "%_IDB%"=="" if exist ..\..\index.db set _IDB=..\..
if "%_IDB%"=="" if exist ..\..\..\index.db set _IDB=..\..\..
if not "%_IDB%"=="" goto MakeIDB
if exist icons\nul goto GlobalKDB
if exist keywords.kdb goto LocalKDB
echo -------------------------------------------------------------------------------
echo Warning:  No databases were found.
goto End

:LocalKDB
echo -------------------------------------------------------------------------------
echo Creating local keyword database "keywords.kdb":
echo. 
mkhtmkdb -a -n -xhidden.dir %_AOPT% %_IOPT% >keywords.kdb
goto MakeLinks

:GlobalKDB
echo -------------------------------------------------------------------------------
echo Creating global keyword database "keywords.kdb":
echo. 
mkhtmkdb -a -n -p -xhidden.dir %_AOPT% %_IOPT% >keywords.kdb
goto MakeLinks

:MakeIDB
echo -------------------------------------------------------------------------------
echo Updating index database "%_IDB%\index.db":
echo. 
mkhtmidb -m -xhidden.dir %_IOPT% -eavi -emov -empg -erm <%_IDB%\index.db >%_IDB%\index.$$$
if errorlevel 1 goto IDBError
del %_IDB%\index.db
ren %_IDB%\index.$$$ index.db
if "%_IDB%"=="." setsig
if not exist keywords.kdb goto MakeLinks
echo -------------------------------------------------------------------------------
echo Warning:  Keyword database "keywords.kdb" was not updated!

:MakeLinks
echo -------------------------------------------------------------------------------
echo Updating symlink files:
echo. 
global /f makelink.bat
if errorlevel 1 goto End
echo -------------------------------------------------------------------------------
echo Making indexes and slides for symlinks (pass 2):
echo. 
mkhtmtree
goto End

:MakeChanged
echo -------------------------------------------------------------------------------
echo Making indexes and slides:
echo. 
mkhtmtree
goto End

:IDBError
del %_IDB%\index.$$$
echo -------------------------------------------------------------------------------
echo Error:  Unable to update index database "%_IDB%\index.db" -- Aborting.

:End
echo. 
set _AOPT=
set _IOPT=
set _IDB=
